<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

namespace StemBase\Modules\Shortcodes\Shortcode;

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

use StemBase\Modules\Shortcodes\Shortcode\ShortcodeBase;

class Button extends ShortcodeBase {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $name = "button";
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $version = "1.0";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $help = "";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_usage = "[button link=\"http://site.com/\"]Title[/button]\n[button size=\"medium\" icon=\"icommon icon-circle\" link=\"http://site.com\"]Tittle[/button]";

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_attributes = array(
		array(
			"name"		=> "size",
			"hint"		=> "small|medium|large|extra, default: small"
		),
		array(
			"name"		=> "strech",
			"hint"		=> "yes|no, default: no"
		),
		array(
			"name"		=> "style",
			"hint"		=> "full|border, default: full"
		),
		array(
			"name"		=> "color",
			"hint"		=> "#hexcode, default: skin color"
		),
		array(
			"name"		=> "bg",
			"hint"		=> "#hexcode, default: skin color"
		),
		array(
			"name"		=> "border",
			"hint"		=> "#hexcode, default: skin color"
		),
		array(
			"name"		=> "icon",
			"hint"		=> "icon class, eg: \"icommon icon-checkmark\""
		),
		array(
			"name"		=> "icon_color",
			"hint"		=> "#hexcode, default: skin color"
		),
		array(
			"name"		=> "icon_sep",
			"hint"		=> "#hexcode, default: icon_color"
		),
		array(
			"name"		=> "icon_pos",
			"hint"		=> "left|right|left-sep|right-sep, default: left"
		),
		array(
			"name"		=> "icon_bg",
			"hint"		=> "#hexcode, default: skin color, only for positions with separator"
		),
		array(
			"name"		=> "link",
			"hint"		=> "url for this button"
		),

		array(
			"name"		=> "rel",
			"hint"		=> "index|noindex|follow|nofollow, default: none"
		),

		array(
			"name"		=> "target",
			"hint"		=> "none|_blank, default: none"
		),
		array(
			"name"		=> "class",
			"hint"		=> "custom css class to the wrapping element for future customization"
		),
	);

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($data) {

		$this->loadTemplate();

		$css		= array();
		$style		= array();
		$icon_style = array();
		$icon_css	= array();
		$text_style = array();
		$text_css	= array();
		$vars = $data["vars"];

		if ($data["vars"]["class"]) { $css[] = $data["vars"]["class"]; }

		switch ($data["vars"]["size"]) {
			default:		$css[] = "btn-med"; break;
			case "small":   $css[] = "btn-small";	break;
			case "large":   $css[] = "btn-large";	break;
			case "extra":   $css[] = "btn-extra-large";	break;
		}
		
		switch ($data["vars"]["strech"]) {
			case "yes":   $css[] = "btn-stretch";	break;
		}

		switch ($data["vars"]["style"]) {
			case "border":  $css[] = "btn-empty";	break;
		}

		//if background set the same color to bg and to border to both icon and text
		if ($data["vars"]["bg"]) {

			//if gradient, put the bg only on the button, and set the gradient bg so it wont have borders
			if (stristr($data["vars"]["bg"] , "gradient")) {
				$css[] = "btn-gradient-background";
				$style["background"] = $this->getBackground($data["vars"]["bg"] , "background")["bg_style"];
			} else {			
//				$icon_style["background"] = 
				$style["background"] = $this->getBackground($data["vars"]["bg"] , "background")["bg_style"];			

//				$icon_style["border_color"] = 
				$style["border_color"] = $this->getBackground($data["vars"]["bg"] , "border-color")["bg_style"];			

			}

		}

		//if border, set the same border to icon and text
		if ($data["vars"]["border"]) {
			$icon_style["border_color"] = 
			$style["border_color"] = $this->getBackground($data["vars"]["border"] , "border-color")["bg_style"];			
		}

		//if color set the same color to icon and text
		if ($data["vars"]["color"]) {

			if (stristr($data["vars"]["color"] , "gradient")) {
				$text_style[] = $this->getBackground($data["vars"]["color"] , "background")["bg_style"];
				$text_style[] = "-webkit-background-clip: text; -webkit-text-fill-color: transparent;";
			} else {			
				$icon_style["color"] = 
				$text_style["color"] = $this->getBackground($data["vars"]["color"] , "color")["bg_style"];			
				$icon_style["border-color"] = $this->getBackground($data["vars"]["color"] , "border-color")["bg_style"];			
			}
		}

		if ($vars["icon_sep"]) {
			$icon_style["border-color"] = $this->getBackground($data["vars"]["icon_sep"] , "border-color")["bg_style"];			
		}
		
		
		if ($data["vars"]["icon"]) {

			$sep = false;

			$icon_css[] = $data["vars"]["icon"];

			switch ($data["vars"]["icon_pos"]) {
				case "left":		$css[] = "btn-icon-left";	break;
				case "right":		$css[] = "btn-icon-right";	break;
				case "left-sep":	$css[] = "btn-icon-left-border";	$sep = true ; break;
				case "right-sep":	$css[] = "btn-icon-right-border";	$sep = true ; break;
			}

			//set the new color just for icon
			if ($data["vars"]["icon_color"]) {
				$icon_style["color"] = $this->getBackground($data["vars"]["icon_color"] , "color")["bg_style"];			
			}

			//set the new color just for icon
			if ($data["vars"]["icon_bg"] && $sep == true) {
				$icon_style["background"] = $this->getBackground($data["vars"]["icon_bg"] , "background")["bg_style"];			
			}


			$icon = $this->tpl->blockReplace(
				"Icon",
				array(
					"css"		=> implode(" " , $icon_css),
					"style"		=> implode(" " , $icon_style),
				),
				$icon_bg
			);
		}

		$button = array(
			"css"		=> implode(" " , $css),
			"style"		=> implode(" " , $style),
			"css_text"	=> implode(" " , $text_css),
			"style_text"=> implode(" " , $text_style),

			"content"	=> $data["vars"]["content"],
			"icon"		=> $icon,
			"target"	=> $data["vars"]["target"],
			"rel"		=> $data["vars"]["rel"],
			"link"		=> $data["vars"]["link"],
		);		
		

		return array(
			"content"	=> $this->tpl->blockReplace(
				"Main",
				$button,
				$bg
			),
			"before"	=> "",
			"after"		=> "",
		);
	}

	
}